*** Figure 1: Great Migration and Northern Whites' Attitudes


cd "$path"
global data "$path/data/"
global output "$path/results"


estimates clear 

*** OPEN MAIN ANES DTA (STATE-LEVEL)
use  "$data/main_ANES.dta", clear

keep if white==1

foreach i in totpop negtot whtot{
gen D6040_`i'=(`i'_60-`i'_40)/100000
} 
.

* set globals for controls

global county_c 	dem_40 fr_bl40 mf_sh40 urb_sh40 pct_CIO_39
global ind_c 		i.age i.female i.educ_mycodes i.married


keep if 		    year==1964



* Regressions 

reg D6040_negtot  $county_c $ind_c  D6040_totpop   i.region [aw=weight], cl(statefip) 
predict z, resid

 
*a) 
reg mip_pro_integr  $county_c $ind_c  D6040_totpop   i.region [aw=weight] , cl(statefip) 
predict y4, resid
 
binscatter y4 z , line(lfit) nquantiles(30) legend(off) xtitle("1940-1960 Change Black population") ///
ytitle("") ylabel(-.1(.05).2,nogrid) xlabel(-1.5(.5)1.5,nogrid) graphregion(fcolor(white) lcolor(white)) 

graph export "$output/Figure1_a.eps", replace

 
*b) 
reg therm_blks  $county_c $ind_c  D6040_totpop   i.region [aw=weight] , cl(statefip) 
predict y, resid

binscatter y z , line(lfit) nquantiles(30) legend(off) xtitle("1940-1960 Change Black population") ///
ytitle("") ylabel(-10(5)10,nogrid) xlabel(-1.5(.5)1.5,nogrid) graphregion(fcolor(white) lcolor(white)) 
graph export "$output/Figure1_b.eps", replace



*c) 
reg therm_NAACP  $county_c $ind_c  D6040_totpop   i.region [aw=weight] , cl(statefip) 
predict y2, resid

binscatter y2 z , line(lfit) nquantiles(30) legend(off) xtitle("1940-1960 Change Black population") ///
ytitle("") ylabel(-8(4)8,nogrid) xlabel(-1.5(.5)1.5,nogrid) graphregion(fcolor(white) lcolor(white)) 
graph export "$output/Figure1_c.eps", replace



*d) 
reg therm_CORE  $county_c $ind_c  D6040_totpop   i.region [aw=weight] , cl(statefip) 
predict y3, resid
 
binscatter y3 z , line(lfit) nquantiles(30) legend(off) xtitle("1940-1960 Change Black population") ///
ytitle("") ylabel(-10(5)10,nogrid) xlabel(-1.5(.5)1.5,nogrid) graphregion(fcolor(white) lcolor(white)) 
graph export "$output/Figure1_d.eps", replace

